/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.thirdapp;

import org.jeecg.config.thirdapp.ThirdAppTypeConfig;
import org.jeecg.config.thirdapp.ThirdAppTypeItemVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ThirdAppConfig {
    public static final String DINGTALK = "DINGTALK";
    public static final String WECHAT_ENTERPRISE = "WECHAT_ENTERPRISE";
    @Value(value="${third-app.enabled:false}")
    private boolean enabled;
    @Autowired
    private ThirdAppTypeConfig type;

    public boolean isEnabled() {
        return this.enabled;
    }

    public ThirdAppConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ThirdAppTypeItemVo getWechatEnterprise() {
        return this.type.getWECHAT_ENTERPRISE();
    }

    public ThirdAppTypeItemVo getDingtalk() {
        return this.type.getDINGTALK();
    }

    public boolean isWechatEnterpriseEnabled() {
        try {
            return this.enabled && this.getWechatEnterprise().isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDingtalkEnabled() {
        try {
            return this.enabled && this.getDingtalk().isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }
}

