import Vue from 'vue'
import App from './App'
import store from './store' // store
import plugins from './plugins' // plugins
import './permission' // permission
import share from 'utils/share.js'//share.js
import uView from '@/uni_modules/uview-ui'
Vue.use(uView)

Vue.use(plugins)

Vue.config.productionTip = false
Vue.prototype.$store = store

App.mpType = 'app'

Vue.mixin(share)
// 创建一个空的Vue实例作为事件中心
Vue.prototype.$eventHub = new Vue()

// 创建全局变量
Vue.prototype.$globalData = {
	isAgree:false,
	submitData: {
		"phone": "",
		"wechatId": "",
		"note": "",
		"totalPrice": "",
		"address": {
			"province": "",
			"city": "",
			"district": "",
			"detailAddress": ""
		},
		"skuList": [],
		"service": {
			"serviceFrequency": "once_a_day",
			"serviceDate": [],
			"serviceTimeFirst": "",
			"serviceTimeSecond": "",
			"pet": []
		}
	},
	mainSku:[],
	augmentedSku:[],
	itemPrices:[],
	servicePrices:[],
	openIdStr:'',
	confirmData: {
		phone: "",
		wechatId: "",
		note: "",
	},
	newOrderData:{
		currentAddress:{},
		currentPets:[],
		totalPrice:0,
		needPreFamiliarize:[]
	}
}

const app = new Vue({
	...App
})

app.$mount()
