import upload from '@/utils/upload'
import request from '@/utils/request'

// 用户密码重置
export function updateUserPwd(oldPassword, newPassword) {
  const data = {
    oldPassword,
    newPassword
  }
  return request({
    url: '/system/user/profile/updatePwd',
    method: 'put',
    params: data
  })
}

// 查询用户个人信息
export function getUserProfile() {
  return request({
    url: '/system/user/profile',
    method: 'get'
  })
}

// 修改用户个人信息
export function updateUserProfile(data) {
  return request({
    url: '/system/user/profile',
    method: 'put',
    data: data
  })
}

// 用户头像上传
export function uploadAvatar(data) {
  return upload({
    url: '/system/user/profile/avatar',
    name: data.name,
    filePath: data.filePath
  })
}
// 人员列表
export function getStaffList(){
	return request({
	  url: '/h5/staff/list',
	  method: 'get'
	})
}
// 产品列表
export function getProductList(data){
	return request({
	  url: '/no-auth/product/list',
	  method: 'post',
	  data:data
	})
}

// 产品详情
export function getProductDetails(data){
	return request({
	  url: `/no-auth/product/detail/${data}`,
	  method: 'get',
	})
}

// 字典
export function getDictList(type){
	return request({
	  url: `/h5/system/dict/data/type/${type}`,
	  method: 'get'
	})
}
//获取openId
export function getOpenId(code){
	return request({
	  url: `/no-auth/wechat/getOpenId?code=${code}`,
	  method: 'get'
	})
}
// 创建订单
export function createOrder(data){
	return request({
	  url: `/no-auth/appointment/add`,
	  method: 'post',
	  data:data
	})
}

// 创建订单新
export function createOrderNew(data){
	return request({
	  url: `/h5/appointment/add`,
	  method: 'post',
		headers:{ "isToken":true},
	  data:data
	})
}

export function getOrderList(data){
	return request({
	  url: `/h5/order/listByOpenid?status=${data.status}&openid=${data.openId}&page=${data.page}&size=${data.size}`,
	  method: 'get'
	})
}
export function getBannerList(){
	return request({
	  url: `/h5/system/dict/data/type/sys_banner`,
	  method: 'get'
	})
}

export function getCity(){
	return request({
	  url: `/h5/system/config/order.city.list`,
	  method: 'get'
	})
}
export function getCouponList(){
	return request({
	  url: `/h5/coupon/list`,
	  headers:{ "isToken":true},
	  method: 'get'
	})
}

export function receiveCoupon(data){
	return request({
	  url: `/h5/coupon/get`,
	  headers:{ "isToken":true},
	  method: 'post',
	  data
	})
}

export function getCouponListNoAuth(){
	return request({
	  url: `/no-auth/h5/coupon/list`,
	  method: 'get'
	})
}

//获取手机号
export function getPhoneNumber(data){
	return request({
	  url: `/no-auth/wechat/getPhoneNumber`,
	  method: 'post',
	  data
	})
}





