import request from '@/utils/request'

// 宠物列表
export function getPetList(data){
	return request({
	  url: '/h5/ums/pet/list',
	  headers:{ "isToken":true},
	  method: 'post'
	})
}
// 删除宠物
export function delPet(id){
	return request({
	  url: `/h5/ums/pet/${id}`,
	  headers:{ "isToken":true},
	  method: 'delete'
	})
}

// 宠物详情
export function getPetDetails(id){
	return request({
	  url: `/h5/ums/pet/${id}`,
	  headers:{ "isToken":true},
	  method: 'get',
	})
}
// 新增宠物
export function addPet(data){
	return request({
	  url: `/h5/ums/pet`,
	  headers:{ "isToken":true},
	  method: 'post',
	  data:data
	})
}
// 修改宠物信息
export function updatePet(data){
	return request({
	  url: `/h5/ums/pet`,
	  headers:{ "isToken":true},
	  method: 'put',
	  data:data
	})
}





