import upload from '@/utils/upload'
import request from '@/utils/request'

// 地址列表
export function getAddressList(data){
	return request({
	  url: '/h5/member/address/list',
	  headers:{ "isToken":true},
	  method: 'post',
	  data:data
	})
}
// 删除地址
export function delAddress(id){
	return request({
	  url: `/h5/member/address/${id}`,
	  headers:{ "isToken":true},
	  method: 'delete'
	})
}

// 地址详情
export function getAddressDetails(id){
	return request({
	  url: `/h5/member/address/${id}`,
	  headers:{ "isToken":true},
	  method: 'get',
	})
}
// 新增地址
export function addAddress(data){
	return request({
	  url: `/h5/member/address/create`,
	  headers:{ "isToken":true},
	  method: 'post',
	  data:data
	})
}
// 修改地址信息
export function updateAddress(data){
	return request({
	  url: `/h5/member/address/update`,
	  headers:{ "isToken":true},
	  method: 'put',
	  data:data
	})
}





