/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.dbPhone.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.dbPhone.entity.DbPhone;
import org.jeecg.modules.dbPhone.service.IDbPhoneService;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u7535\u8bdd\u53bb\u91cd\u590d\u8868"})
@RestController
@RequestMapping(value={"/dbPhone/dbPhone"})
public class DbPhoneController
extends JeecgController<DbPhone, IDbPhoneService> {
    private static final Logger log = LoggerFactory.getLogger(DbPhoneController.class);
    @Autowired
    private IDbPhoneService dbPhoneService;
    @Resource
    private RedisUtil redisUtil;

    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<DbPhone>> queryPageList(DbPhone dbPhone, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<DbPhone> queryWrapper = QueryGenerator.initQueryWrapper(dbPhone, req.getParameterMap());
        if (StringUtils.isNotBlank((String)dbPhone.getSort())) {
            queryWrapper.eq((Object)"sort", (Object)dbPhone.getSort());
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dbPhoneService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK(pageList);
    }

    @AutoLog(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6dfb\u52a0", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody DbPhone dbPhone) {
        this.dbPhoneService.save(dbPhone);
        return Result.OK("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u7f16\u8f91", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody DbPhone dbPhone) {
        this.dbPhoneService.updateById(dbPhone);
        return Result.OK("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.dbPhoneService.removeById((Serializable)((Object)id));
        return Result.OK("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6279\u91cf\u5220\u9664", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.dbPhoneService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u7535\u8bdd\u53bb\u91cd\u590d\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<DbPhone> queryById(@RequestParam(name="id", required=true) String id) {
        DbPhone dbPhone = (DbPhone)this.dbPhoneService.getById((Serializable)((Object)id));
        if (dbPhone == null) {
            return Result.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK(dbPhone);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, DbPhone dbPhone) {
        return super.exportXls(request, dbPhone, DbPhone.class, "\u7535\u8bdd\u53bb\u91cd\u590d\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<DbPhone> finalDataList = new ArrayList<DbPhone>();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            try {
                List<DbPhone> listFromExcel = this.readExcelByRow(file.getInputStream(), params);
                HashSet<String> uniquePhoneNumbers = new HashSet<String>();
                for (DbPhone item : listFromExcel) {
                    String phoneNumber = item.getPhone();
                    if (uniquePhoneNumbers.contains(phoneNumber) || this.existsByPhoneNumber(phoneNumber)) continue;
                    uniquePhoneNumbers.add(phoneNumber);
                    finalDataList.add(item);
                }
                int batchSize = 1000;
                for (int i = 0; i < finalDataList.size(); i += batchSize) {
                    int end = Math.min(i + batchSize, finalDataList.size());
                    List batch = finalDataList.subList(i, end);
                    long start = System.currentTimeMillis();
                    ((IDbPhoneService)this.service).saveBatch(batch);
                    log.info("\u5bfc\u5165\u5e76\u8fc7\u6ee4\u91cd\u590d\u6570\u636e\u6d88\u8017\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
                }
                return Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u5df2\u5bfc\u5165\u6570\u636e\u884c\u6570\uff1a" + finalDataList.size());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                log.error(msg, (Throwable)e);
                return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01\u672a\u627e\u5230\u6709\u6548\u7684\u4e0a\u4f20\u6587\u4ef6\u3002");
    }

    public boolean existsByPhoneNumber(String phoneNumber) {
        String cacheKey = "phone_number:" + phoneNumber;
        Boolean existsInCache = (Boolean)this.redisUtil.get(cacheKey);
        if (existsInCache != null) {
            return existsInCache;
        }
        DbPhone one = (DbPhone)((LambdaQueryChainWrapper)((IDbPhoneService)this.service).lambdaQuery().eq(DbPhone::getPhone, (Object)phoneNumber)).one();
        if (one != null) {
            this.redisUtil.set(cacheKey, (Object)true);
            return true;
        }
        this.redisUtil.set(cacheKey, (Object)false);
        return false;
    }

    private List<DbPhone> readExcelByRow(InputStream inputStream, ImportParams params) throws IOException {
        ArrayList<DbPhone> resultList = new ArrayList<DbPhone>();
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.iterator();
        int titleRows = params.getTitleRows();
        int headRows = params.getHeadRows();
        int skipRows = titleRows + headRows;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() < skipRows) continue;
            DbPhone dbPhone = new DbPhone();
            String phoneNumber = this.getCellValue(row.getCell(0));
            dbPhone.setPhone(phoneNumber);
            dbPhone.setSort(this.getCellValue(row.getCell(1)));
            resultList.add(dbPhone);
        }
        workbook.close();
        return resultList;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        return "";
    }
}

