/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.dbInfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.dbConf.entity.DbConf;
import org.jeecg.modules.dbConf.service.IDbConfService;
import org.jeecg.modules.dbInfo.entity.DbInfo;
import org.jeecg.modules.dbInfo.service.IDbInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4fe1\u606f\u63cf\u8ff0\u8868"})
@RestController
@RequestMapping(value={"/dbInfo/dbInfo"})
public class DbInfoController
extends JeecgController<DbInfo, IDbInfoService> {
    private static final Logger log = LoggerFactory.getLogger(DbInfoController.class);
    @Autowired
    private IDbInfoService dbInfoService;
    @Autowired
    private IDbConfService dbConfService;

    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<DbInfo>> queryPageList(DbInfo dbInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<DbInfo> queryWrapper = QueryGenerator.initQueryWrapper(dbInfo, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.dbInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK(pageList);
    }

    @AutoLog(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6dfb\u52a0", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody DbInfo dbInfo) {
        this.dbInfoService.save(dbInfo);
        if (StringUtils.isNotBlank((String)dbInfo.getConfId())) {
            String url = ((DbConf)this.dbConfService.getById((Serializable)((Object)dbInfo.getConfId()))).getUrl();
            dbInfo.setConfUrl(url + dbInfo.getId());
        }
        this.dbInfoService.updateById(dbInfo);
        return Result.OK("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u7f16\u8f91", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody DbInfo dbInfo) {
        if (StringUtils.isNotBlank((String)dbInfo.getConfId())) {
            String url = ((DbConf)this.dbConfService.getById((Serializable)((Object)dbInfo.getConfId()))).getUrl();
            dbInfo.setConfUrl(url + dbInfo.getId());
        }
        this.dbInfoService.updateById(dbInfo);
        return Result.OK("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.dbInfoService.removeById((Serializable)((Object)id));
        return Result.OK("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6279\u91cf\u5220\u9664", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.dbInfoService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u4fe1\u606f\u63cf\u8ff0\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u4fe1\u606f\u63cf\u8ff0\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<DbInfo> queryById(@RequestParam(name="id", required=true) String id) {
        DbInfo dbInfo = (DbInfo)this.dbInfoService.getById((Serializable)((Object)id));
        if (dbInfo == null) {
            return Result.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK(dbInfo);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, DbInfo dbInfo) {
        return super.exportXls(request, dbInfo, DbInfo.class, "\u4fe1\u606f\u63cf\u8ff0\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, DbInfo.class);
    }
}

