/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.shiro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.annotation.Resource;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisClusterManager;
import org.crazycake.shiro.RedisManager;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeeccgBaseConfig;
import org.jeecg.config.shiro.ShiroRealm;
import org.jeecg.config.shiro.filters.CustomShiroFilterFactoryBean;
import org.jeecg.config.shiro.filters.JwtFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@Configuration
public class ShiroConfig {
    private static final Logger log = LoggerFactory.getLogger(ShiroConfig.class);
    @Resource
    LettuceConnectionFactory lettuceConnectionFactory;
    @Autowired
    private Environment env;
    @Autowired
    JeeccgBaseConfig jeeccgBaseConfig;

    @Bean(value={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        CustomShiroFilterFactoryBean shiroFilterFactoryBean = new CustomShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        String shiroExcludeUrls = this.jeeccgBaseConfig.getShiro().getExcludeUrls();
        if (oConvertUtils.isNotEmpty(shiroExcludeUrls)) {
            String[] permissionUrl;
            for (String url : permissionUrl = shiroExcludeUrls.split(",")) {
                filterChainDefinitionMap.put(url, "anon");
            }
        }
        filterChainDefinitionMap.put("/api/**", "anon");
        filterChainDefinitionMap.put("/api/getConfList", "anon");
        filterChainDefinitionMap.put("/order/getVipCode", "anon");
        filterChainDefinitionMap.put("/order/wxTechnicianLogin", "anon");
        filterChainDefinitionMap.put("/api/notify", "anon");
        filterChainDefinitionMap.put("/order/getVipShareSign", "anon");
        filterChainDefinitionMap.put("/post/notify", "anon");
        filterChainDefinitionMap.put("/sys/oss/file/upload", "anon");
        filterChainDefinitionMap.put("/sys/common/upload", "anon");
        filterChainDefinitionMap.put("/sys/cas/client/validateLogin", "anon");
        filterChainDefinitionMap.put("/sys/randomImage/**", "anon");
        filterChainDefinitionMap.put("/sys/checkCaptcha", "anon");
        filterChainDefinitionMap.put("/sys/login", "anon");
        filterChainDefinitionMap.put("/sys/mLogin", "anon");
        filterChainDefinitionMap.put("/sys/logout", "anon");
        filterChainDefinitionMap.put("/sys/thirdLogin/**", "anon");
        filterChainDefinitionMap.put("/sys/getEncryptedString", "anon");
        filterChainDefinitionMap.put("/sys/sms", "anon");
        filterChainDefinitionMap.put("/sys/phoneLogin", "anon");
        filterChainDefinitionMap.put("/sys/user/checkOnlyUser", "anon");
        filterChainDefinitionMap.put("/sys/user/register", "anon");
        filterChainDefinitionMap.put("/sys/user/phoneVerification", "anon");
        filterChainDefinitionMap.put("/sys/user/passwordChange", "anon");
        filterChainDefinitionMap.put("/auth/2step-code", "anon");
        filterChainDefinitionMap.put("/sys/common/static/**", "anon");
        filterChainDefinitionMap.put("/sys/common/pdf/**", "anon");
        filterChainDefinitionMap.put("/generic/**", "anon");
        filterChainDefinitionMap.put("/sys/getLoginQrcode/**", "anon");
        filterChainDefinitionMap.put("/sys/getQrcodeToken/**", "anon");
        filterChainDefinitionMap.put("/sys/checkAuth", "anon");
        filterChainDefinitionMap.put("/", "anon");
        filterChainDefinitionMap.put("/doc.html", "anon");
        filterChainDefinitionMap.put("/**/*.js", "anon");
        filterChainDefinitionMap.put("/**/*.css", "anon");
        filterChainDefinitionMap.put("/**/*.html", "anon");
        filterChainDefinitionMap.put("/**/*.svg", "anon");
        filterChainDefinitionMap.put("/**/*.pdf", "anon");
        filterChainDefinitionMap.put("/**/*.jpg", "anon");
        filterChainDefinitionMap.put("/**/*.png", "anon");
        filterChainDefinitionMap.put("/**/*.ico", "anon");
        filterChainDefinitionMap.put("/**/*.ttf", "anon");
        filterChainDefinitionMap.put("/**/*.woff", "anon");
        filterChainDefinitionMap.put("/**/*.woff2", "anon");
        filterChainDefinitionMap.put("/druid/**", "anon");
        filterChainDefinitionMap.put("/swagger-ui.html", "anon");
        filterChainDefinitionMap.put("/swagger**/**", "anon");
        filterChainDefinitionMap.put("/webjars/**", "anon");
        filterChainDefinitionMap.put("/v2/**", "anon");
        filterChainDefinitionMap.put("/sys/annountCement/show/**", "anon");
        filterChainDefinitionMap.put("/jmreport/**", "anon");
        filterChainDefinitionMap.put("/**/*.js.map", "anon");
        filterChainDefinitionMap.put("/**/*.css.map", "anon");
        filterChainDefinitionMap.put("/test/bigScreen/**", "anon");
        filterChainDefinitionMap.put("/websocket/**", "anon");
        filterChainDefinitionMap.put("/newsWebsocket/**", "anon");
        filterChainDefinitionMap.put("/vxeSocket/**", "anon");
        filterChainDefinitionMap.put("/v1/**", "anon");
        filterChainDefinitionMap.put("/actuator/**", "anon");
        filterChainDefinitionMap.put("/test/seata/**", "anon");
        HashMap<String, JwtFilter> filterMap = new HashMap<String, JwtFilter>(1);
        String cloudServer = this.env.getProperty("spring.cloud.nacos.discovery.server-addr");
        filterMap.put("jwt", new JwtFilter(cloudServer == null));
        shiroFilterFactoryBean.setFilters(filterMap);
        filterChainDefinitionMap.put("/**", "jwt");
        shiroFilterFactoryBean.setUnauthorizedUrl("/sys/common/403");
        shiroFilterFactoryBean.setLoginUrl("/sys/common/403");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean(value={"securityManager"})
    public DefaultWebSecurityManager securityManager(ShiroRealm myRealm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)myRealm);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        securityManager.setSubjectDAO((SubjectDAO)subjectDAO);
        securityManager.setCacheManager((CacheManager)this.redisCacheManager());
        return securityManager;
    }

    @Bean
    @DependsOn(value={"lifecycleBeanPostProcessor"})
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        defaultAdvisorAutoProxyCreator.setProxyTargetClass(true);
        defaultAdvisorAutoProxyCreator.setUsePrefix(true);
        defaultAdvisorAutoProxyCreator.setAdvisorBeanNamePrefix("_no_advisor");
        return defaultAdvisorAutoProxyCreator;
    }

    @Bean
    public static LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(DefaultWebSecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager((SecurityManager)securityManager);
        return advisor;
    }

    public RedisCacheManager redisCacheManager() {
        log.info("===============(1)\u521b\u5efa\u7f13\u5b58\u7ba1\u7406\u5668RedisCacheManager");
        RedisCacheManager redisCacheManager = new RedisCacheManager();
        redisCacheManager.setRedisManager(this.redisManager());
        redisCacheManager.setPrincipalIdFieldName("id");
        redisCacheManager.setExpire(200000);
        return redisCacheManager;
    }

    @Bean
    public IRedisManager redisManager() {
        RedisManager manager;
        log.info("===============(2)\u521b\u5efaRedisManager,\u8fde\u63a5Redis..");
        if (this.lettuceConnectionFactory.getClusterConfiguration() == null || this.lettuceConnectionFactory.getClusterConfiguration().getClusterNodes().isEmpty()) {
            RedisManager redisManager = new RedisManager();
            redisManager.setHost(this.lettuceConnectionFactory.getHostName());
            redisManager.setPort(this.lettuceConnectionFactory.getPort());
            redisManager.setDatabase(this.lettuceConnectionFactory.getDatabase());
            redisManager.setTimeout(0);
            if (!StringUtils.isEmpty((Object)this.lettuceConnectionFactory.getPassword())) {
                redisManager.setPassword(this.lettuceConnectionFactory.getPassword());
            }
            manager = redisManager;
        } else {
            RedisClusterManager redisManager = new RedisClusterManager();
            HashSet portSet = new HashSet();
            this.lettuceConnectionFactory.getClusterConfiguration().getClusterNodes().forEach(node -> portSet.add(new HostAndPort(node.getHost(), node.getPort().intValue())));
            if (oConvertUtils.isNotEmpty(this.lettuceConnectionFactory.getPassword())) {
                JedisCluster jedisCluster = new JedisCluster(portSet, 2000, 2000, 5, this.lettuceConnectionFactory.getPassword(), new GenericObjectPoolConfig());
                redisManager.setPassword(this.lettuceConnectionFactory.getPassword());
                redisManager.setJedisCluster(jedisCluster);
            } else {
                JedisCluster jedisCluster = new JedisCluster(portSet);
                redisManager.setJedisCluster(jedisCluster);
            }
            manager = redisManager;
        }
        return manager;
    }
}

