/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.dynamic.db;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.codegenerate.generate.util.SimpleFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerParseFactory {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerParseFactory.class);
    private static final String ENCODE = "utf-8";
    private static final String MINI_DAO_FORMAT = "DaoFormat";
    private static final Configuration TPL_CONFIG = new Configuration();
    private static final Configuration SQL_CONFIG = new Configuration();
    private static StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private static final Pattern NOTES_PATTERN = Pattern.compile("(?ms)/\\*.*?\\*/|^\\s*//.*?$");

    public static boolean isExistTemplate(String tplName) throws Exception {
        try {
            Template mytpl = TPL_CONFIG.getTemplate(tplName, "UTF-8");
            if (mytpl == null) {
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                log.error(e.getMessage(), e.fillInStackTrace());
                throw new Exception(e);
            }
            log.debug("----isExistTemplate----" + e.toString());
            return false;
        }
        return true;
    }

    public static String parseTemplate(String tplName, Map<String, Object> paras) {
        try {
            log.debug(" minidao sql templdate : " + tplName);
            StringWriter swriter = new StringWriter();
            Template mytpl = TPL_CONFIG.getTemplate(tplName, ENCODE);
            if (paras.containsKey(MINI_DAO_FORMAT)) {
                throw new RuntimeException("DaoFormat \u662f minidao \u4fdd\u7559\u5173\u952e\u5b57\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528 \uff0c\u8bf7\u66f4\u6539\u53c2\u6570\u5b9a\u4e49\uff01");
            }
            paras.put(MINI_DAO_FORMAT, new SimpleFormat());
            mytpl.process(paras, (Writer)swriter);
            String sql = FreemarkerParseFactory.getSqlText(swriter.toString());
            paras.remove(MINI_DAO_FORMAT);
            return sql;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.fillInStackTrace());
            log.error("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplName + " }");
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    public static String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        try {
            String sqlUnderline = "sql_";
            StringWriter swriter = new StringWriter();
            if (stringTemplateLoader.findTemplateSource(sqlUnderline + tplContent.hashCode()) == null) {
                stringTemplateLoader.putTemplate(sqlUnderline + tplContent.hashCode(), tplContent);
            }
            Template mytpl = SQL_CONFIG.getTemplate(sqlUnderline + tplContent.hashCode(), ENCODE);
            if (paras.containsKey(MINI_DAO_FORMAT)) {
                throw new RuntimeException("DaoFormat \u662f minidao \u4fdd\u7559\u5173\u952e\u5b57\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528 \uff0c\u8bf7\u66f4\u6539\u53c2\u6570\u5b9a\u4e49\uff01");
            }
            paras.put(MINI_DAO_FORMAT, new SimpleFormat());
            mytpl.process(paras, (Writer)swriter);
            String sql = FreemarkerParseFactory.getSqlText(swriter.toString());
            paras.remove(MINI_DAO_FORMAT);
            return sql;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e.fillInStackTrace());
            log.error("\u53d1\u9001\u4e00\u6b21\u7684\u6a21\u677fkey:{ " + tplContent + " }");
            throw new RuntimeException("\u89e3\u6790SQL\u6a21\u677f\u5f02\u5e38");
        }
    }

    private static String getSqlText(String sql) {
        sql = NOTES_PATTERN.matcher(sql).replaceAll("");
        sql = sql.replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("\\s{1,}", " ").trim();
        String whereSpace = "where ";
        String whereAnd = "where and";
        String commaWhere = ", where";
        String commaSpace = ", ";
        if (sql.endsWith("where") || sql.endsWith(whereSpace)) {
            sql = sql.substring(0, sql.lastIndexOf("where"));
        }
        int index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)whereAnd, (int)index)) != -1) {
            sql = sql.substring(0, index + 5) + sql.substring(index + 9, sql.length());
        }
        index = 0;
        while ((index = StringUtils.indexOfIgnoreCase((CharSequence)sql, (CharSequence)commaWhere, (int)index)) != -1) {
            sql = sql.substring(0, index) + sql.substring(index + 1, sql.length());
        }
        if (sql.endsWith(",") || sql.endsWith(commaSpace)) {
            sql = sql.substring(0, sql.lastIndexOf(","));
        }
        return sql;
    }

    static {
        TPL_CONFIG.setClassForTemplateLoading(new FreemarkerParseFactory().getClass(), "/");
        TPL_CONFIG.setNumberFormat("0.#####################");
        SQL_CONFIG.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        SQL_CONFIG.setNumberFormat("0.#####################");
        SQL_CONFIG.setClassicCompatible(true);
    }
}

