/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.filter;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileTypeFilter {
    private static String[] forbidType = new String[]{"jsp", "php"};
    static final HashMap<String, String> FILE_TYPE_MAP = new HashMap();

    private static String getFileTypeBySuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
    }

    public static void fileTypeFilter(MultipartFile file) throws Exception {
        String suffix = FileTypeFilter.getFileType(file);
        for (String type : forbidType) {
            if (!type.contains(suffix)) continue;
            throw new Exception("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38\uff1a" + suffix);
        }
    }

    private static String getFileType(MultipartFile file) throws Exception {
        String fileExtendName = null;
        try {
            InputStream is = file.getInputStream();
            byte[] b = new byte[10];
            is.read(b, 0, b.length);
            String fileTypeHex = String.valueOf(FileTypeFilter.bytesToHexString(b));
            for (String key : FILE_TYPE_MAP.keySet()) {
                if (!key.toLowerCase().startsWith(fileTypeHex.toLowerCase().substring(0, 5)) && !fileTypeHex.toLowerCase().substring(0, 5).startsWith(key.toLowerCase())) continue;
                fileExtendName = FILE_TYPE_MAP.get(key);
                break;
            }
            if (StringUtils.isBlank(fileExtendName)) {
                String fileName = file.getOriginalFilename();
                return FileTypeFilter.getFileTypeBySuffix(fileName);
            }
            is.close();
            return fileExtendName;
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage(), exception);
        }
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        FILE_TYPE_MAP.put("3c25402070616765206c", "jsp");
        FILE_TYPE_MAP.put("3c3f7068700a0a2f2a2a0a202a205048", "php");
    }
}

