/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.jeecg.common.util.MinioUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.filter.FileTypeFilter;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.oss.OssBootUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static Pattern ZHONGWEN_PATTERN = Pattern.compile("[\u4e00-\u9fa5]");
    private static String FILE_NAME_REGEX = "[^A-Za-z\\.\\(\\)\\-\uff08\uff09\\_0-9\\u4e00-\\u9fa5]";
    private static String DB_TYPE = "";
    private static DbType dbTypeEnum = null;

    public static String uploadOnlineImage(byte[] data, String basePath, String bizPath, String uploadType) {
        String dbPath = null;
        String fileName = "image" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName((byte[])data);
        try {
            if ("local".equals(uploadType)) {
                File file = new File(basePath + File.separator + bizPath + File.separator);
                if (!file.exists()) {
                    file.mkdirs();
                }
                String savePath = file.getPath() + File.separator + fileName;
                File savefile = new File(savePath);
                FileCopyUtils.copy((byte[])data, (File)savefile);
                dbPath = bizPath + File.separator + fileName;
            } else {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                String relativePath = bizPath + "/" + fileName;
                if ("minio".equals(uploadType)) {
                    dbPath = MinioUtil.upload(in, relativePath);
                } else if ("alioss".equals(uploadType)) {
                    dbPath = OssBootUtil.upload(in, relativePath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbPath;
    }

    public static String getFileName(String fileName) {
        int pos;
        int unixSep = fileName.lastIndexOf(47);
        int winSep = fileName.lastIndexOf(92);
        int n = pos = winSep > unixSep ? winSep : unixSep;
        if (pos != -1) {
            fileName = fileName.substring(pos + 1);
        }
        fileName = fileName.replace("=", "").replace(",", "").replace("&", "").replace("#", "").replace("\u201c", "").replace("\u201d", "");
        fileName = fileName.replaceAll("\\s", "");
        fileName = fileName.replaceAll(FILE_NAME_REGEX, "");
        return fileName;
    }

    public static boolean ifContainChinese(String str) {
        if (str.getBytes().length == str.length()) {
            return false;
        }
        Matcher m = ZHONGWEN_PATTERN.matcher(str);
        return m.find();
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath) : OssBootUtil.upload(file, bizPath);
        return url;
    }

    public static String uploadLocal(MultipartFile mf, String bizPath, String uploadpath) {
        try {
            FileTypeFilter.fileTypeFilter(mf);
            String fileName = null;
            File file = new File(uploadpath + File.separator + bizPath + File.separator);
            if (!file.exists()) {
                file.mkdirs();
            }
            String orgName = mf.getOriginalFilename();
            fileName = (orgName = CommonUtils.getFileName(orgName)).indexOf(".") != -1 ? orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf(".")) : orgName + "_" + System.currentTimeMillis();
            String savePath = file.getPath() + File.separator + fileName;
            File savefile = new File(savePath);
            FileCopyUtils.copy((byte[])mf.getBytes(), (File)savefile);
            String dbpath = null;
            dbpath = oConvertUtils.isNotEmpty(bizPath) ? bizPath + File.separator + fileName : fileName;
            if (dbpath.contains("\\")) {
                dbpath = dbpath.replace("\\", "/");
            }
            return dbpath;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static String upload(MultipartFile file, String bizPath, String uploadType, String customBucket) {
        String url = "";
        url = "minio".equals(uploadType) ? MinioUtil.upload(file, bizPath, customBucket) : OssBootUtil.upload(file, bizPath, customBucket);
        return url;
    }

    @Deprecated
    public static String getDatabaseType() {
        if (oConvertUtils.isNotEmpty(DB_TYPE)) {
            return DB_TYPE;
        }
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        try {
            return CommonUtils.getDatabaseTypeByDataSource(dataSource);
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static DbType getDatabaseTypeEnum() {
        if (oConvertUtils.isNotEmpty(dbTypeEnum)) {
            return dbTypeEnum;
        }
        try {
            DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
            dbTypeEnum = JdbcUtils.getDbType((String)dataSource.getConnection().getMetaData().getURL());
            return dbTypeEnum;
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DataSourceProperty getDataSourceProperty(String sourceKey) {
        DynamicDataSourceProperties prop = (DynamicDataSourceProperties)SpringContextUtils.getApplicationContext().getBean(DynamicDataSourceProperties.class);
        Map map = prop.getDatasource();
        DataSourceProperty db = (DataSourceProperty)map.get(sourceKey);
        return db;
    }

    public static Connection getDataSourceConnect(String sourceKey) throws SQLException {
        DynamicDataSourceProperties prop;
        Map map;
        DataSourceProperty db;
        if (oConvertUtils.isEmpty(sourceKey)) {
            sourceKey = "master";
        }
        if ((db = (DataSourceProperty)(map = (prop = (DynamicDataSourceProperties)SpringContextUtils.getApplicationContext().getBean(DynamicDataSourceProperties.class)).getDatasource()).get(sourceKey)) == null) {
            return null;
        }
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setDriverClassName(db.getDriverClassName());
        ds.setUrl(db.getUrl());
        ds.setUsername(db.getUsername());
        ds.setPassword(db.getPassword());
        return ds.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        if ("".equals(DB_TYPE)) {
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData md = connection.getMetaData();
                String dbType = md.getDatabaseProductName().toUpperCase();
                String sqlserver = "SQL SERVER";
                if (dbType.indexOf("MYSQL") >= 0) {
                    DB_TYPE = "MYSQL";
                } else if (dbType.indexOf("ORACLE") >= 0 || dbType.indexOf("DM") >= 0) {
                    DB_TYPE = "ORACLE";
                } else if (dbType.indexOf("SQLSERVER") >= 0 || dbType.indexOf(sqlserver) >= 0) {
                    DB_TYPE = "SQLSERVER";
                } else if (dbType.indexOf("POSTGRESQL") >= 0) {
                    DB_TYPE = "POSTGRESQL";
                } else if (dbType.indexOf("MARIADB") >= 0) {
                    DB_TYPE = "MARIADB";
                } else {
                    log.error("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        String xGatewayBasePath = request.getHeader("X_GATEWAY_BASE_PATH");
        if (oConvertUtils.isNotEmpty(xGatewayBasePath)) {
            log.info("x_gateway_base_path = " + xGatewayBasePath);
            return xGatewayBasePath;
        }
        String scheme = request.getHeader("X-Forwarded-Scheme");
        if (oConvertUtils.isEmpty(scheme)) {
            scheme = request.getScheme();
        }
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        String baseDomainPath = null;
        int length = 80;
        baseDomainPath = length == serverPort ? scheme + "://" + serverName + contextPath : scheme + "://" + serverName + ":" + serverPort + contextPath;
        log.info("-----Common getBaseUrl----- : " + baseDomainPath);
        return baseDomainPath;
    }
}

