/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.bean.ConvertUtils;
import org.jeecg.modules.bean.HttpConf;
import org.jeecg.modules.bean.LoginReq;
import org.jeecg.modules.hanHaiMember.entity.HanHaiMember;
import org.jeecg.modules.hanHaiMember.service.IHanHaiMemberService;
import org.jeecg.modules.service.ApiLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApiLoginServiceImpl
implements ApiLoginService {
    private static final Logger log = LoggerFactory.getLogger(ApiLoginServiceImpl.class);
    @Resource
    private IHanHaiMemberService hanHaiMemberService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private HttpConf httpConf;
    @Value(value="${weixin.mpAppId}")
    private String mpAppId;
    @Value(value="${weixin.mpAppSecret}")
    private String mpAppSecret;

    @Override
    @Transactional
    public Result<?> officialLogin(LoginReq loginReq) {
        HashMap<String, Object> loginMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)loginReq.getCode())) {
            throw new JeecgBootException("code\u4e3a\u7a7a");
        }
        String loginUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + this.mpAppId + "&secret=" + this.mpAppSecret + "&code=" + loginReq.getCode() + "&grant_type=authorization_code";
        JSONObject json_test = this.httpConf.getJSONObject(loginUrl);
        log.info("{} {} -- {}", new Object[]{this.mpAppId, this.mpAppSecret, json_test});
        String wxOpenid = json_test.getString("openid");
        String wxUnionId = json_test.getString("unionid");
        String access_token = json_test.getString("access_token");
        if (StringUtils.isBlank((String)wxOpenid)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230openid");
        }
        HanHaiMember member = (HanHaiMember)((LambdaQueryChainWrapper)this.hanHaiMemberService.lambdaQuery().eq(HanHaiMember::getOfficialOpenid, (Object)wxOpenid)).one();
        if (member != null) {
            String memberUrl = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + wxOpenid + "&lang=zh_CN";
            JSONObject json_member = this.httpConf.getJSONObject(memberUrl);
            String nickname = json_member.getString("nickname");
            String headimgurl = json_member.getString("headimgurl");
            try {
                nickname = new String(nickname.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            member.setNickName(nickname);
            member.setHeadImage(headimgurl);
            member.setWxUnionid(wxUnionId);
            String token = JwtUtil.sign(member.getAccount(), member.getAccount());
            member.setToken(token);
            member.setUpdateTime(new Date());
            this.hanHaiMemberService.updateById(member);
            this.redisUtil.set("prefix_user_token_" + token, (Object)token);
            this.redisUtil.expire("prefix_user_token_" + token, 3600000L);
            loginMap.put("token", token);
            loginMap.put("userInfo", member);
            return Result.OK("\u767b\u5f55\u6210\u529f", loginMap);
        }
        String memberUrl = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + wxOpenid + "&lang=zh_CN";
        JSONObject json_member = this.httpConf.getJSONObject(memberUrl);
        String nickname = json_member.getString("nickname");
        String headimgurl = json_member.getString("headimgurl");
        try {
            nickname = new String(nickname.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HanHaiMember save = new HanHaiMember();
        save.setAccount(wxOpenid);
        save.setVid(loginReq.getVid());
        save.setVtime(new Date());
        save.setNickName(nickname);
        save.setHeadImage(headimgurl);
        save.setWxUnionid(wxUnionId);
        save.setShareId(loginReq.getShareId());
        save.setOfficialOpenid(wxOpenid);
        save.setCreateTime(new Date());
        String salt = ConvertUtils.randomGen(8);
        String encrypt = PasswordUtil.encrypt(wxOpenid, "123456", salt);
        save.setPassword(encrypt);
        save.setPasswordSalt(salt);
        save.setDeleteFlag("N");
        save.setRole("0");
        String token = JwtUtil.sign(wxOpenid, wxOpenid);
        save.setToken(token);
        this.hanHaiMemberService.save(save);
        this.redisUtil.set("prefix_user_token_" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token_" + token, 3600000L);
        loginMap.put("token", token);
        loginMap.put("userInfo", save);
        return Result.OK("\u767b\u5f55\u6210\u529f", loginMap);
    }
}

