/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.hotelbanner.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.hotelbanner.entity.HotelBanner;
import org.jeecg.modules.hotelbanner.service.IHotelBannerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"hotel_banner"})
@RestController
@RequestMapping(value={"/hotelbanner/hotelBanner"})
public class HotelBannerController
extends JeecgController<HotelBanner, IHotelBannerService> {
    private static final Logger log = LoggerFactory.getLogger(HotelBannerController.class);
    @Autowired
    private IHotelBannerService hotelBannerService;

    @ApiOperation(value="hotel_banner-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="hotel_banner-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<HotelBanner>> queryPageList(HotelBanner hotelBanner, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<HotelBanner> queryWrapper = QueryGenerator.initQueryWrapper(hotelBanner, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.hotelBannerService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK(pageList);
    }

    @AutoLog(value="hotel_banner-\u6dfb\u52a0")
    @ApiOperation(value="hotel_banner-\u6dfb\u52a0", notes="hotel_banner-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody HotelBanner hotelBanner) {
        this.hotelBannerService.save(hotelBanner);
        return Result.OK("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="hotel_banner-\u7f16\u8f91")
    @ApiOperation(value="hotel_banner-\u7f16\u8f91", notes="hotel_banner-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody HotelBanner hotelBanner) {
        this.hotelBannerService.updateById(hotelBanner);
        return Result.OK("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="hotel_banner-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="hotel_banner-\u901a\u8fc7id\u5220\u9664", notes="hotel_banner-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.hotelBannerService.removeById((Serializable)((Object)id));
        return Result.OK("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="hotel_banner-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="hotel_banner-\u6279\u91cf\u5220\u9664", notes="hotel_banner-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.hotelBannerService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="hotel_banner-\u901a\u8fc7id\u67e5\u8be2", notes="hotel_banner-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<HotelBanner> queryById(@RequestParam(name="id", required=true) String id) {
        HotelBanner hotelBanner = (HotelBanner)this.hotelBannerService.getById((Serializable)((Object)id));
        if (hotelBanner == null) {
            return Result.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK(hotelBanner);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, HotelBanner hotelBanner) {
        return super.exportXls(request, hotelBanner, HotelBanner.class, "hotel_banner");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, HotelBanner.class);
    }
}

