/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils2 {
    private static String YYYY = "yyyy";
    private static String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    private static String YYYYMMDD = "yyyy-MM-dd";
    private static String YYYYMM = "yyyy-MM";
    private static String HHMMSS = "HH:mm:ss";
    private static String YYYYMMDD2 = "yyyyMMdd";
    private static String YYYYMMDDHHMMSS2 = "yyyyMMddHHmmss";
    private static String YYYYMMDD3 = "yyyy\u5e74MM\u6708dd\u65e5";
    private static String DD = "dd";
    private static String MM = "MM";
    public static String DEFUALT_TIME_START = " 00:00:00";
    public static String DEFUALT_TIME_END = " 23:59:59";

    public static String getNowDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowYear() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYY);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowMonth() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(MM);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDay() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DD);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDateString() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDD2);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDateString2() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDD3);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDateStrings() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS2);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowTime(long time) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(time).atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(HHMMSS);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getTodayDate() {
        LocalDateTime localDateTime = LocalDateTime.now().atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDD);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowYearMonth() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMM);
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowMonthMaxDay() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDD);
        LocalDateTime with = localDateTime.with(TemporalAdjusters.lastDayOfMonth());
        String format = dateTimeFormatter.format(with);
        return format.substring(8, 10);
    }

    public static String getMaxDay() {
        LocalDateTime localDateTime = LocalDateTime.now();
        LocalDateTime with = localDateTime.with(TemporalAdjusters.lastDayOfMonth());
        return null;
    }

    public static String getmilsMoveDate(Long time) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(time).atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        return formatter.format(localDateTime);
    }

    public static String getmilsMoveDates(Long time) {
        LocalDateTime localDateTime = Instant.ofEpochMilli(time).atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDD);
        return formatter.format(localDateTime);
    }

    public static String getYYYYMMDDHHMMSS(Date date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static Date getDate(String date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        LocalDateTime localDateTime = LocalDateTime.parse(date, dateTimeFormatter);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date getDate(String date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateTime.parse(date, dateTimeFormatter);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static LocalDateTime dateToDateTime(Date date) {
        Instant instant = date.toInstant();
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static Date dateTimeToDate(LocalDateTime localDateTime) {
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static LocalDate dateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate;
    }

    public static Date localToDate(LocalDate localDate) {
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static LocalTime dateToLocalTime(Date date) {
        Instant instant = date.toInstant();
        LocalTime localTime = instant.atZone(ZoneId.systemDefault()).toLocalTime();
        return localTime;
    }

    public static Date localToDate(LocalTime localTime) {
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static String getYYYYMMDD(Date date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDD);
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static String getYYYYMM(Date date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMM);
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static Date afterXDateTimeMIN(Date date, int after) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.plusDays(after);
        localDateTime = localDateTime.with(LocalTime.MIN);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date afterXDateTimeMAX(Date date, int after) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.plusDays(after);
        localDateTime = localDateTime.with(LocalTime.MAX);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date beforeXDateTimeMIN(Date date, int before) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.minusDays(before);
        localDateTime = localDateTime.with(LocalTime.MIN);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date beforeXDateTimeMAX(Date date, int before) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.minusDays(before);
        localDateTime = localDateTime.with(LocalTime.MAX);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String currentFirstDayOfMonth() {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static String currentLastDayOfMonth() {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static Date currentXDayOfMonth(Date date) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date beforeXFirstDayOfMonth(Date date) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static String preXDayOfMonthMIN(int month) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static String preXDayOfMonthMIN2(int month) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMM);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static String preXDayOfMonthMIN3(int month) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(MM);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static Date preXDayOfMonthMIN(Date date, int month) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.firstDayOfMonth()).with(LocalTime.MIN);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date preXDayOfMonth(Date date, int month) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.minusMonths(month);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Date afterXDayOfMonth(Date date, int month) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.plusMonths(month);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static String preXDayOfMonthMAX(int month) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(YYYYMMDDHHMMSS);
        Date date = DateUtils2.dateTimeToDate(localDateTime);
        localDateTime = DateUtils2.dateToDateTime(date);
        return formatter.format(localDateTime);
    }

    public static Date preXDayOfMonthMAX(Date date, int month) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.minusMonths(month);
        localDateTime = localDateTime.with(TemporalAdjusters.lastDayOfMonth()).with(LocalTime.MAX);
        return DateUtils2.dateTimeToDate(localDateTime);
    }

    public static Long getUntilMonth(Date date1, Date date2) {
        LocalDate localDate1 = DateUtils2.dateToLocalDate(date1);
        LocalDate localDate2 = DateUtils2.dateToLocalDate(date2);
        return ChronoUnit.MONTHS.between(localDate1, localDate2);
    }

    public static Long getUntilDay(Date date1, Date date2) {
        LocalDate localDate1 = DateUtils2.dateToLocalDate(date1);
        LocalDate localDate2 = DateUtils2.dateToLocalDate(date2);
        return ChronoUnit.DAYS.between(localDate1, localDate2);
    }

    public static Long getUntilHours(Date date1, Date date2) {
        LocalDateTime localDate1 = DateUtils2.dateToDateTime(date1);
        LocalDateTime localDate2 = DateUtils2.dateToDateTime(date2);
        Long senonds = Duration.between(localDate1, localDate2).get(ChronoUnit.SECONDS);
        return senonds / 3600L;
    }

    public static double getUntilHoursByDouble(Date date1, Date date2) {
        LocalDateTime localDate1 = DateUtils2.dateToDateTime(date1);
        LocalDateTime localDate2 = DateUtils2.dateToDateTime(date2);
        Long seconds = Duration.between(localDate1, localDate2).get(ChronoUnit.SECONDS);
        BigDecimal secondss = BigDecimal.valueOf(seconds);
        BigDecimal hours = secondss.divide(BigDecimal.valueOf(3600L), 2, 4);
        return hours.doubleValue();
    }

    public static Long getUntilSecond(Date date1, Date date2) {
        LocalDateTime localDate1 = DateUtils2.dateToDateTime(date1);
        LocalDateTime localDate2 = DateUtils2.dateToDateTime(date2);
        return Duration.between(localDate1, localDate2).get(ChronoUnit.SECONDS);
    }

    public static Date currentMax(Date date) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.with(LocalTime.MAX);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date currentMin(Date date) {
        LocalDateTime localDateTime = DateUtils2.dateToDateTime(date);
        localDateTime = localDateTime.with(LocalTime.MIN);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Long getMilliSecond(String date) {
        Timestamp timestamp = Timestamp.valueOf(date);
        return timestamp.getTime();
    }

    public static final String getFirstWeekDay(int num) {
        LocalDate localDate = LocalDate.now().plusWeeks(num);
        LocalDate with = localDate.with(DayOfWeek.MONDAY);
        String firstDay = with + " 00:00:00";
        return firstDay;
    }

    public static final String getLastWeekDay(int num) {
        LocalDate localDate = LocalDate.now().plusWeeks(num);
        LocalDate with = localDate.with(DayOfWeek.SUNDAY);
        String firstDay = with + " 23:59:59";
        return firstDay;
    }

    public static final Long getTodayZero() {
        Long current = System.currentTimeMillis();
        Long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        return zero;
    }

    public static final Long getTodayTwelve() {
        Long current = System.currentTimeMillis();
        Long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Long twelve = zero + 86400000L - 1L;
        return twelve;
    }

    public static final String getYesterday() {
        LocalDate today = LocalDate.now();
        String yesterday = today.plusDays(-1L).toString();
        return yesterday;
    }

    public static String plusDate(String startdate, int days) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYYMMDD);
        try {
            Date date = sdf.parse(startdate);
            long ltime = date.getTime();
            long ldays = (long)days * 86400000L;
            Date newDay = new Date(ltime + ldays);
            return DateUtils2.getDateString(newDay, YYYYMMDD);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDateString(Date date, String format) {
        SimpleDateFormat toDateFormat = new SimpleDateFormat(format);
        String d = toDateFormat.format(date);
        return d;
    }
}

