/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.payOrder.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.payOrder.entity.PayOrder;
import org.jeecg.modules.payOrder.service.IPayOrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868"})
@RestController
@RequestMapping(value={"/payOrder/payOrder"})
public class PayOrderController
extends JeecgController<PayOrder, IPayOrderService> {
    private static final Logger log = LoggerFactory.getLogger(PayOrderController.class);
    @Autowired
    private IPayOrderService payOrderService;

    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<PayOrder>> queryPageList(PayOrder payOrder, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<PayOrder> queryWrapper = QueryGenerator.initQueryWrapper(payOrder, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.payOrderService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK(pageList);
    }

    @AutoLog(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6dfb\u52a0", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody PayOrder payOrder) {
        this.payOrderService.save(payOrder);
        return Result.OK("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u7f16\u8f91", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody PayOrder payOrder) {
        this.payOrderService.updateById(payOrder);
        return Result.OK("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u901a\u8fc7id\u5220\u9664", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<String> delete(@RequestParam(name="id", required=true) String id) {
        this.payOrderService.removeById((Serializable)((Object)id));
        return Result.OK("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6279\u91cf\u5220\u9664", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.payOrderService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f!");
    }

    @ApiOperation(value="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u901a\u8fc7id\u67e5\u8be2", notes="\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<PayOrder> queryById(@RequestParam(name="id", required=true) String id) {
        PayOrder payOrder = (PayOrder)this.payOrderService.getById((Serializable)((Object)id));
        if (payOrder == null) {
            return Result.error("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK(payOrder);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, PayOrder payOrder) {
        return super.exportXls(request, payOrder, PayOrder.class, "\u77e5\u8bc6\u4ed8\u8d39\u8ba2\u5355\u8868");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PayOrder.class);
    }
}

