/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.bean.HttpConf;
import org.jeecg.modules.bean.LoginReq;
import org.jeecg.modules.hanHaiMember.entity.HanHaiMember;
import org.jeecg.modules.hanHaiMember.service.IHanHaiMemberService;
import org.jeecg.modules.service.AppletLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppletLoginServiceImpl
implements AppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(AppletLoginServiceImpl.class);
    private static final String mpAppId = "wx3c24e397e3b132ea";
    private static final String mpAppSecret = "21b26094216042af6cb0d148a90ecac2";
    @Resource
    private IHanHaiMemberService memberService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private HttpConf httpConf;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Object> appletLogin(LoginReq loginReq) {
        Result<Object> result = new Result<Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)loginReq.getCode())) {
            throw new JeecgBootException("\u5c0f\u7a0b\u5e8fcode\u4e3a\u7a7a");
        }
        String loginUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=wx3c24e397e3b132ea&secret=21b26094216042af6cb0d148a90ecac2&js_code=" + loginReq.getCode() + "&grant_type=authorization_code";
        JSONObject json_test = this.httpConf.getJSONObject(loginUrl);
        String wxOpenid = json_test.getString("openid");
        String sessionKey = json_test.getString("session_key");
        if (StringUtils.isBlank((CharSequence)wxOpenid)) {
            throw new JeecgBootException("\u672a\u83b7\u53d6\u5230openid");
        }
        HanHaiMember member = (HanHaiMember)((LambdaQueryChainWrapper)this.memberService.lambdaQuery().eq(HanHaiMember::getAppOpenid, (Object)wxOpenid)).one();
        if (member == null) {
            loginReq.setOpenid(wxOpenid);
            loginReq.setSession_key(sessionKey);
            member = new HanHaiMember();
            member.setAppletOpenid(wxOpenid);
            member.setNickName(loginReq.getNickName());
            member.setHeadImage(loginReq.getHeadimgurl());
            String token = JwtUtil.sign(member.getAppletOpenid(), wxOpenid);
            this.redisUtil.set("prefix_user_token_" + token, (Object)token);
            this.redisUtil.expire("prefix_user_token_" + token, 36000L);
            map.put("userInfo", member);
            map.put("token", token);
            result.setCode(905);
            result.setResult(map);
            return result;
        }
        member.setHeadImage(loginReq.getHeadimgurl());
        this.memberService.saveOrUpdate(member);
        String token = JwtUtil.sign(member.getAppletOpenid(), wxOpenid);
        this.redisUtil.set("prefix_user_token_" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token_" + token, 36000L);
        map.put("userInfo", member);
        map.put("token", token);
        result.setResult(map);
        result.setCode(200);
        return result;
    }
}

