/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.oConvertUtils;
import org.jeecgframework.dict.service.AutoPoiDictServiceI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AutoPoiDictConfig
implements AutoPoiDictServiceI {
    private static final Logger log = LoggerFactory.getLogger(AutoPoiDictConfig.class);
    static final String EXCEL_SPLIT_TAG = "_";
    static final String TEMP_EXCEL_SPLIT_TAG = "---";
    @Lazy
    @Resource
    private CommonAPI commonApi;

    public String[] queryDict(String dicTable, String dicCode, String dicText) {
        ArrayList<String> dictReplaces = new ArrayList<String>();
        List<DictModel> dictList = null;
        if (oConvertUtils.isEmpty(dicTable)) {
            dictList = this.commonApi.queryDictItemsByCode(dicCode);
        } else {
            try {
                dicText = oConvertUtils.getString(dicText, dicCode);
                dictList = this.commonApi.queryTableDictItemsByCode(dicTable, dicText, dicCode);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        for (DictModel t : dictList) {
            if (t == null) continue;
            if (t.getValue().contains(EXCEL_SPLIT_TAG)) {
                String val = t.getValue().replace(EXCEL_SPLIT_TAG, TEMP_EXCEL_SPLIT_TAG);
                dictReplaces.add(t.getText() + EXCEL_SPLIT_TAG + val);
                continue;
            }
            dictReplaces.add(t.getText() + EXCEL_SPLIT_TAG + t.getValue());
        }
        if (dictReplaces != null && dictReplaces.size() != 0) {
            log.info("---AutoPoi--Get_DB_Dict------" + ((Object)dictReplaces).toString());
            return dictReplaces.toArray(new String[dictReplaces.size()]);
        }
        return null;
    }
}

